#include <iostream>
#include <vector>

#define ll long long

using namespace std;

const int N = 10000006;
const int sqrtN=10000;

bool prosti[N];

int smallp[]={2,3,5,7,11,13,17,19,23,29,31,37,41, 43, 47, 53};

vector<int> primes;

ll binexp(ll n, ll k, ll mod)
{
    ll r=1;
    while(k>0)
    {
        if(k%2)
        {
            r=(r*n)%mod;
        }
        k/=2;
        n=(n*n)%mod;
    }
    return r;
}

bool is_candidate(int n, int p)
{
    int l=n-1;
    int k=__builtin_ctz(l);
    l>>=k;
    ll pl=binexp(p, l, n);
    if((pl-1)%n==0)
        return true;
    while(k)
    {
        if((pl+1)%n==0)
            return true;
        pl=(pl*pl)%n;
        k--;
    }
    return false;
}

bool is_prime(int n)
{
    if(n==1)
        return false;
    if(n==2 || n==3)
        return true;
    if(!(n%2))
        return false;
    for(int i=0; i<16; i++)
        if(n==smallp[i])
            return true;
    for(int i=0; i<16; i++)
        if(n%smallp[i]==0)
            return false;
    for(int i=0; i<16; i++)
        if(!is_candidate(n,smallp[i]))
            return false;
    return true;
}

void get_primes()
{
    primes.push_back(2);
    for(int i=3; i<sqrtN; i+=2)
    {
        if(is_prime(i))
            primes.push_back(i);
    }
    for(int i=0; i<primes.size(); i++)
    {
        int p=primes[i];
        for(int j=2; p*j<N; j++)
        {
            prosti[p*j]=false;
        }
    }
    for(int i=sqrtN; i<N; i++)
        if(prosti[i])
            primes.push_back(i);
}

int binary(int n, int l=0, int r = primes.size()) ///broj prostih <=n
{
    if(l==r)
        return l;
    int m = (l+r)/2;
    int p = primes[m];
    if(n<p)
        return binary(n, l, m);
    return binary(n,m+1,r);
}

int brprostih(int n)
{
    return binary(n)-binary(n/2);
}

int query(int n)
{
    return n-brprostih(n)-1;
}

int main()
{
    for(int i=0; i<N;i++)
        prosti[i]=true;
    get_primes();
    int q;
    cin>>q;
    while(q)
    {
        int n;
        cin>>n;
        cout<<query(n)<<endl;
        q--;
    }
    return 0;
}


/**
p^(n-1)=1
p^(n-1)-1=0
n-1=2^k*l
(p^l-1)(p^l+1)(p^2l+1)(...)(p^2^(k-1)l+1)=0
2658251
1299721
46817
4837
*/